import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import moonlander.library.*; 
import ddf.minim.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class demo extends PApplet {



Moonlander moonlander;

PShader bufA_effect0;
PShader bufB_effect0;
PShader bufC_effect0;
PShader bufD_effect0;
PShader bufE_effect0;
AudioPlayer player;
Minim minim;
int starttt;

PGraphics tex0;
PGraphics duptex0; 
PGraphics tex1;
PGraphics duptex1; 
PGraphics tex2;
PGraphics duptex2; 
PGraphics tex3;
PGraphics duptex3; 
PImage duptex0image;
PImage duptex1image;
PImage duptex2image;
PImage duptex3image;

public void setup() {
  
  //size(320, 200, P3D);
  noCursor();
  background(0);
  noStroke();
  fill(2);
  tex0 = createGraphics( width, height, P3D );
  tex1 = createGraphics( width, height, P3D );
  tex2 = createGraphics( width, height, P3D );
  tex3 = createGraphics( width, height, P3D );
  bufA_effect0 = loadShader("frag0.glsl", "vert.glsl");
  bufB_effect0 = loadShader("frag1.glsl", "vert.glsl");
  bufC_effect0 = loadShader("frag2.glsl", "vert.glsl");
  bufD_effect0 = loadShader("frag3.glsl", "vert.glsl");
  bufE_effect0 = loadShader("frag4.glsl", "vert.glsl");
  textureMode(NORMAL);
  minim = new Minim(this);
  moonlander = Moonlander.initWithSoundtrack(this, "sanmi_-_08_-_CosmosF.mp3",128, 4);
    moonlander.start("localhost", 1338, "syncdata.rocket");
  starttt = millis();
}
public void effect0() {
  bufA_effect0.set("iChannel0", tex0);
  bufA_effect0.set("iChannel1", tex1);
  bufA_effect0.set("iChannel2", tex2);
  bufA_effect0.set("iChannel3", tex3);
  bufB_effect0.set("iChannel0", tex0);
  bufB_effect0.set("iChannel1", tex1);
  bufB_effect0.set("iChannel2", tex2);
  bufB_effect0.set("iChannel3", tex3);
  bufC_effect0.set("iChannel0", tex0);
  bufC_effect0.set("iChannel1", tex1);
  bufC_effect0.set("iChannel2", tex2);
  bufC_effect0.set("iChannel3", tex3);
  
  tex0.shader(bufA_effect0);
  tex0.beginShape();
  tex0.translate(0, 0);
  tex0.rect(0, 0, width, height);
  tex0.endShape();
  
  tex1.shader(bufB_effect0);
  tex1.beginShape();
  tex1.translate(0, 0);
  tex1.rect(0, 0, width, height);
  tex1.endShape();
  
  tex2.shader(bufC_effect0);
  tex2.beginShape();
  tex2.translate(0, 0);
  tex2.rect(0, 0, width, height);
  tex2.endShape();
}
public void draw() {
    moonlander.update();
  float time = (float)moonlander.getValue("time");
  float scene = (float)moonlander.getValue("scene");

  bufA_effect0.set("iResolution", PApplet.parseFloat(width), PApplet.parseFloat(height));
  bufA_effect0.set("iGlobalTime", time);
  
  bufB_effect0.set("iResolution", PApplet.parseFloat(width), PApplet.parseFloat(height));
  bufB_effect0.set("iGlobalTime", time);
  
  bufC_effect0.set("iResolution", PApplet.parseFloat(width), PApplet.parseFloat(height));
  bufC_effect0.set("iGlobalTime", time);
  
  bufD_effect0.set("iResolution", PApplet.parseFloat(width), PApplet.parseFloat(height));
  bufD_effect0.set("iGlobalTime", time);
  
  bufE_effect0.set("iResolution", PApplet.parseFloat(width), PApplet.parseFloat(height));
  bufE_effect0.set("iGlobalTime", time);
  
  effect0();
  
  background(0);
  translate(0, 0);
  beginShape();
  translate(0, 0);
  rect(0, height/4, width, height/2);
  texture(tex0);
  endShape();
  if(scene == 0.0f) {
    shader(bufA_effect0);
  }
  if(scene == 1.0f) {
    shader(bufB_effect0);
  }
  if(scene == 2.0f) {
    shader(bufC_effect0);
  }
  if(scene == 3.0f) {
    shader(bufD_effect0);
  }
  if(scene == 4.0f) {
    shader(bufE_effect0);
  }
  if(scene == 5.0f) {
    exit();
  }
}

public void stop()
{
  player.close();
  minim.stop();
  super.stop();
}
  public void settings() {  fullScreen(P3D); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "demo" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
